#include <SFML/Graphics.hpp>
#include <ZLE.hpp>

int main()
{
    sf::RenderWindow window(sf::VideoMode({400, 400}), "Level example");
    window.setFramerateLimit(60);

    zle::Level level;
    level.loadFromFile("level.zle", "");
    level.setScale({ 5.f, 5.f });

    sf::Clock clk;
    while (window.isOpen())
    {
        while (auto event = window.pollEvent())
        {
            if (event->is<sf::Event::Closed>())
                window.close();
        }
        sf::Time delta = clk.restart();
        //Update all particle systems
        for (auto& n : level.getLevelMap())
            if (n.second.getObjectType() == zle::ObjectType::ParticleSystem)
                n.second.getParticleSystem()->Update(delta);

        window.clear();
        window.draw(level);
        window.display();
    }

    return 0;
}